<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeContract extends Model 
{

    protected $table = 'employee_contracts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('employee_id', 'registration_id', 'begin_date', 'end_date', 'contract_type', 'begin_in_experience', 'begin_experience_days', 'determined_time');
    protected $visible = array('employee_id', 'registration_id', 'begin_date', 'end_date', 'contract_type', 'begin_in_experience', 'begin_experience_days', 'determined_time');

    public function employee()
    {
        return $this->belongsTo('Merchant\Entities\Employee', 'employee_id', 'id');
    }

}